using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using PdfSrvr; //new subscription license
using MagSrvr; //new subscription license


/*****************************************************************/
/* Tokenworks PDF417 and Magnetic Stripe Parsing Library         */
/*  Copyright 2025 TokenWorks Inc.   All rights reserved.       */
/* Redistribution and use of this code in source and/or binary   */
/* forms, with or without modification, are permitted provided   */
/* that: (1) all copies of the source code retain the above      */
/* unmodified copyright notice and this entire unmodified        */
/* section of text, (2) You or Your organization owns a valid    */
/* Developer License to this product from TokenWorks Inc.        */
/* and, (3) when any portion of this code is bundled in any      */
/* form with an application, a valid notice must be provided     */
/* within the user documentation, start-up screen or in the      */
/* help-about section of the application that specifies          */
/* TokenWorks as the provider of the Software bundled            */
/* with the application.                                         */
/*****************************************************************/

//SDK version 4.1.0.9 - Server ID/DL Parsing library demo for .net, Final release, updates Class for pdf

// Files required in .net deploy directory:
//PLUSManaged.XmlSerializers.dll - Key logic
//LicenseManager.exe - Tool to activate License
//LicMgrHelp.chm - help file for License Manager
//PdfSrvr.dll - Barcode parsing library
//MagSrvr.dll - Magstripe parsing library
//SrvrPrsrlic.lfx - License file, unique file created by the License manager, This license file must be in same directory as LicenseManager app and is unique for every machine.

// Files required in Asp.net deploy directory:
//For Asp.net deployments, the License file (SrvrPrsrlic.lfx) will be in root directory, same directory as web.config, 
//Also, the LicenseManager.exe and the LicMgrHelp.chm must be in the same directory as the license file.
// The Parsing libraries and the Key Logic DLL can be in a sub folder, please see the SDK project: SampleParserWebApi for example
namespace ServerParseDemo
{
    public partial class frmMain : Form
    {
        MagSrvr.Magstripe mc;
        PdfSrvr.Barcode bc;

        #region Local Variables
        string stateP_DL;
        string cityP_DL;
        string addrP_DL;
        string firstnameP_DL;
        string lastnameP_DL;
        string titleP_DL;
        string midnameP_DL;
        string dlP_DL;
        string expP_DL;
        string dobyearP_DL;
        string dobMMDDP_DL;
        string zipP_DL;
        string HeightP_DL;
        string EyeColorP_DL;
        string SexP_DL;
        string ClassP_DL;
        string RestrictionsP_DL;
        string EndorsementsP_DL;
        string WeightP_DL;
        string HairP_DL;



        byte[] MagBuff = new byte[315]; //Magstrip reader buffer size limit
        byte[] buff = new byte[2000]; // PDF417 barcode reader buffer size limit


        string displaystring;


        #endregion


        public frmMain()
        {
            InitializeComponent();


        }

        #region Local Functions

        /// <summary> Convert a string of hex digits (ex: E4 CA B2) to a byte array. </summary>
        /// <param name="s"> The string containing the hex digits (with or without spaces). </param>
        /// <returns> Returns an array of bytes. </returns>
        public static byte[] HexStringToByteArray(string s)
        {
            s = s.Replace(" ", "");
            byte[] buffer = new byte[s.Length / 2];
            for (int i = 0; i < s.Length; i += 2)
                buffer[i / 2] = (byte)Convert.ToByte(s.Substring(i, 2), 16);
            return buffer;
        }

        /// <summary> Converts an array of bytes into a formatted string of hex digits (ex: E4 CA B2)</summary>
        /// <param name="data"> The array of bytes to be translated into a string of hex digits. </param>
        /// <returns> Returns a well formatted string of hex digits with spacing. </returns>
        public string ByteArrayToHexString(byte[] data)
        {
            StringBuilder sb = new StringBuilder(data.Length * 3);
            foreach (byte b in data)
                sb.Append(Convert.ToString(b, 16).PadLeft(2, '0').PadRight(3, ' '));
            return sb.ToString().ToUpper();
        }

        #endregion



        #region Events

        private void btnClear_Click(object sender, EventArgs e)
        {
            txtFirst.Text = "";
            txtLast.Text = "";
            txtMid.Text = "";
            txtTitle.Text = "";
            txtID.Text = "";
            txtState.Text = "";
            txtCity.Text = "";
            txtAddress.Text = "";
            txtEXP.Text = "";
            txtZip.Text = "";
            txtClass.Text = "";
            txtRestriction.Text = "";
            txtEndorsement.Text = "";
            txtSEX.Text = "";
            txtHeight.Text = "";
            txtWeight.Text = "";
            txtHair.Text = "";
            txtEye.Text = "";
            txtDobMMDD.Text = "";
            txtDobYear.Text = "";
            txtCountry.Text = "";
            txtRace.Text = "";
            txtDBD.Text = "";
            txtAddr2.Text = "";
            txtRetMag.Text = "";
            txtRetPDF.Text = "";
            textFirstCC.Text = "";
            textLastCC.Text = "";
            textExpMMCC.Text = "";
            textExpYYCC.Text = "";
            textPanCC.Text = "";
            txtIsoBin.Text = "";
            txtIssuingState.Text = "";


            displaystring = "";
            this.Invoke(new EventHandler(SetText));

            txtKeyStatus.Text = "";
            txtKeyResponse.Text = "";
            txtLicenseID.Text = "";
            txtInstallationID.Text = "";
            txtRev.Text = "";
            txtRealID.Text = "";


        }


        private void btnMagTest_Click(object sender, EventArgs e)
        {
            //Magstripe_Scan is a simulated buffer of magnetic card data, in this case all pre-fix,postfix data has already been removed.
            byte[] Magstripe_Scan = HexStringToByteArray("25 4E 59 41 4C 42 41 4E 59 5E 54 4F 4B 45 4E 57 4F 52 4B 53 24 4A 4F 45 34 24 54 5E 38 33 34 20 43 4F 4E 43 48 20 53 48 45 4C 4C 20 52 44 20 20 20 20 23 39 30 31 5E 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 3F 3B 36 33 36 30 31 30 30 33 32 34 31 36 38 33 36 33 31 33 37 3D 30 37 30 32 31 39 38 34 39 39 30 34 30 3D 3F 25 21 20 31 32 33 34 34 30 30 30 30 20 20 45 20 42 20 20 20 20 20 20 20 20 20 20 20 20 20 31 35 30 36 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 4E 2F 26 2B 47 47 30 30 30 30 30 3F");
            Array.Resize(ref MagBuff, Magstripe_Scan.Length); //You MUST resize the data, the buffer sent must contain only card data, no preceding bytes generated by a scanner, and no trailing garbage data. Normally the length is created from the SerialPort.BytesToRead property.
            Array.Copy(Magstripe_Scan, 0, MagBuff, 0, Magstripe_Scan.Length); // copy the scan from your SerialDataReceivedEventHandler into the global MagBuff array

            try
            {
                this.Invoke(new EventHandler(SendMAG)); // always call the DLLs with a try/catch
            }
            catch
            {
                MessageBox.Show("Invalid Magstripe");
            }
            displaystring = MagSrvr.Magstripe.track1 + MagSrvr.Magstripe.track2 + MagSrvr.Magstripe.track3; // display the ASCII version of the input data
            this.Invoke(new EventHandler(SetText)); 

        }


        private void btnBank_Click(object sender, EventArgs e)
        {
            //BankCard_Scan is a simulated buffer of magnetic card data, in this case all pre-fix,postfix data has already been removed.
            byte[] BankCard_Scan = HexStringToByteArray("25 42 34 37 35 30 31 39 30 31 30 35 31 30 39 37 35 38 5E 47 41 4C 58 49 4D 4F 2F 50 41 42 4C 4F 5E 31 30 30 31 31 30 31 30 30 30 30 30 30 30 30 30 30 31 32 34 30 30 30 30 30 30 30 30 30 30 30 3F 3B 34 37 35 30 31 39 30 31 30 35 31 30 39 37 35 38 3D 31 30 30 31 31 30 31 30 30 30 30 30 30 30 30 30 30 31 32 34 3F 25 4E 44 3F");
            Array.Resize(ref MagBuff, BankCard_Scan.Length); //You MUST resize the data, the buffer sent must contain only card data, no preceding bytes generated by a scanner, and no trailing garbage data. Normally the length is created from the SerialPort.BytesToRead property.
            Array.Copy(BankCard_Scan, 0, MagBuff, 0, BankCard_Scan.Length); // copy the scan from your SerialDataReceivedEventHandler into the global MagBuff array

            try
            {
                this.Invoke(new EventHandler(SendMAG)); // always call the DLLs with a try/catch
            }
            catch
            {
                MessageBox.Show("Invalid Magstripe");
            }
            displaystring = MagSrvr.Magstripe.track1 + MagSrvr.Magstripe.track2 + MagSrvr.Magstripe.track3; // display the ASCII version of the input data
            this.Invoke(new EventHandler(SetText)); 

        }


        private void btnPdfTest_Click(object sender, EventArgs e)
        {
            //BarCode_Scan is a simulated buffer of PDF417 Barcode card data, in this case all pre-fix,postfix data has already been removed.
           // byte[] BarCode_Scan = HexStringToByteArray("40 0A 1C 0D 41 41 4D 56 41 33 36 30 30 31 30 30 31 44 4C 30 30 31 32 33 34 35 36 44 4C 0A 44 41 41 54 4F 4B 45 4E 57 4F 52 4B 53 40 54 4F 4D 40 54 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0A 44 41 47 34 34 20 45 20 39 39 54 48 20 53 54 20 41 50 54 20 39 30 31 0A 44 41 49 4E 45 57 20 59 4F 52 4B 20 20 20 20 20 20 20 0A 44 41 4A 4E 59 0A 44 41 4B 31 30 31 32 38 20 20 20 20 20 20 0A 44 41 51 33 36 32 38 33 32 35 31 32 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0A 20 44 42 42 31 39 38 37 30 38 30 32 0A 44 42 44 32 30 30 30 31 30 30 34 0A 44 42 41 32 30 31 33 30 35 30 37 0A 44 41 52 44 4D 20 20 0A 44 41 53 20 20 20 20 20 20 20 20 20 20 0A 44 41 54 20 20 20 20 20 20 0A 44 42 43 4D 0A 44 41 55 36 30 32 0A 44 41 59 42 52 20 0A 44 42 4B 20 20 20 20 20 20 20 20 20 0A 44 42 48 20 20 20 20 20 20 20 20 20 20 0D");
            // Alternate test scan below with all fields DBD=20001231  
            //byte[] BarCode_Scan = HexStringToByteArray("40 0A 1E 0D 41 4E 53 49 20 36 33 36 30 31 30 30 31 30 32 44 4C 30 30 33 39 30 31 37 38 5A 46 30 32 31 37 30 30 36 35 44 4C 44 41 41 50 45 52 4B 4B 4F 2C 4A 52 2C 50 41 55 4C 2C 56 41 55 47 48 4E 0A 44 41 47 32 32 32 32 20 48 41 4E 4B 53 20 44 52 49 56 45 0A 44 41 49 46 54 20 4D 59 45 52 53 0A 44 41 4A 46 4C 0A 44 41 4B 33 33 39 30 35 2D 32 34 33 35 20 0A 44 41 51 50 36 36 36 37 39 38 30 30 36 32 36 30 0A 44 41 52 45 20 20 20 0A 44 41 53 4E 4F 4E 45 0A 44 41 54 4E 4F 4E 45 0A 44 42 41 32 30 32 33 30 34 30 36 0A 44 42 42 32 30 30 30 31 32 33 31 0A 44 42 43 32 0A 44 42 44 32 30 31 35 30 34 30 36 0A 44 43 41 44 4D 0A 44 41 59 47 52 45 45 4E 0A 44 43 42 78 78 78 0A 44 43 44 79 79 79 0A 44 41 57 31 32 35 0A 44 41 5A 42 52 4E 0A 44 44 41 46 0A 44 41 55 35 30 31 0A 44 41 48 41 50 54 20 39 30 31 0A 44 43 4C 57 0A 0D ");
            //everi Address issue (no problem)
            // byte[] BarCode_Scan = HexStringToByteArray("40 0A 1E 0D 41 4E 53 49 20 36 33 36 30 30 34 30 38 30 30 30 32 44 4C 30 30 34 31 30 32 38 30 5A 4E 30 33 32 31 30 30 32 33 44 4C 44 41 51 30 30 30 30 33 35 37 37 34 37 37 30 0A 44 43 53 54 48 4F 4D 50 53 4F 4E 0A 44 44 45 4E 0A 44 41 43 47 52 45 47 4F 52 59 0A 44 44 46 4E 0A 44 41 44 41 4C 41 4E 0A 44 44 47 4E 0A 44 43 41 43 0A 44 43 42 4E 4F 4E 45 0A 44 43 44 4E 4F 4E 45 0A 44 42 44 30 31 33 31 32 30 32 32 0A 44 42 42 31 31 31 36 31 39 37 33 0A 44 42 41 31 31 31 36 32 30 32 38 0A 44 42 43 31 0A 44 41 55 30 37 31 20 69 6E 0A 44 41 59 42 52 4F 0A 44 41 47 36 31 30 20 45 20 42 41 59 53 49 44 45 20 44 52 0A 44 41 49 43 48 4F 43 4F 57 49 4E 49 54 59 0A 44 41 4A 4E 43 0A 44 41 4B 32 37 38 31 37 39 35 36 37 20 20 0A 44 43 46 30 30 33 31 36 37 30 37 34 37 0A 44 43 47 55 53 41 0A 44 41 5A 42 52 4F 0A 44 43 4C 55 20 20 0A 44 43 4B 30 30 30 30 33 35 37 37 34 37 37 30 4E 43 4D 47 53 4C 30 31 0A 44 44 41 46 0A 44 44 42 31 30 32 34 32 30 31 34 0A 44 44 4B 31 0D 5A 4E 5A 4E 41 44 55 50 0A 5A 4E 42 0A 5A 4E 43 30 0A 5A 4E 44 4E 0D");
            //everi Address issue #2 (no problem)
            //byte[] BarCode_Scan = HexStringToByteArray("40 20 30 20 41 4e 53 49 20 36 33 36 30 32 36 30 38 30 31 30 32 44 4c 30 30 34 31 30 32 37 31 5a 41 30 33 31 32 30 30 31 35 44 4c 44 41 51 44 31 31 32 30 36 38 39 31 0a 44 43 53 48 55 46 46 20 44 44 45 4e 20 44 41 43 4a 4f 48 4e 20 44 44 46 4e 20 44 41 44 57 49 4c 4c 49 53 20 44 44 47 4e 20 44 43 41 41 20 44 43 42 4e 4f 4e 45 20 44 43 44 54 50 4e 4d 0a 44 42 44 31 32 31 36 32 30 31 39 20 44 42 42 30 33 32 32 31 39 36 32 20 44 42 41 31 32 31 36 32 30 32 34 20 44 42 43 31 20 44 41 55 30 37 33 20 69 6e 20 44 41 59 42 4c 55 20 44 41 47 31 37 35 39 36 20 57 0a 41 43 41 43 49 41 20 43 54 20 44 41 49 47 4f 4f 44 59 45 41 52 20 44 41 4a 41 5a 20 44 41 4b 38 35 33 33 38 35 37 35 32 20 44 43 46 33 38 35 36 45 33 31 32 30 48 31 36 34 38 4a 32 0a 44 43 47 55 53 41 20 44 41 57 32 35 30 20 44 41 5a 42 52 4f 20 44 43 4b 31 39 33 35 30 41 5a 30 31 35 33 39 33 39 39 31 30 31 30 31 20 44 44 41 46 20 44 44 42 30 32 31 34 32 30 31 34 0a 5a 41 5a 41 41 4e 20 5a 41 42 20 5a 41 43");

            
            // DBD=20241231 (good scan) - v4.1.0.9 this scan is replicated below using a different docissue date
           byte[] BarCode_Scan = HexStringToByteArray("40 0A 1E 0D 41 4E 53 49 20 36 33 36 30 31 30 30 31 30 32 44 4C 30 30 33 39 30 31 37 38 5A 46 30 32 31 37 30 30 36 35 44 4C 44 41 41 50 45 52 4B 4B 4F 2C 4A 52 2C 50 41 55 4C 2C 56 41 55 47 48 4E 0A 44 41 47 32 32 32 32 20 48 41 4E 4B 53 20 44 52 49 56 45 0A 44 41 49 46 54 20 4D 59 45 52 53 0A 44 41 4A 46 4C 0A 44 41 4B 33 33 39 30 35 2D 32 34 33 35 20 0A 44 41 51 50 36 36 36 37 39 38 30 30 36 32 36 30 0A 44 41 52 45 20 20 20 0A 44 41 53 4E 4F 4E 45 0A 44 41 54 4E 4F 4E 45 0A 44 42 41 32 30 32 33 30 34 30 36 0A 44 42 42 32 30 32 32 31 32 33 31 0A 44 42 43 32 0A 44 42 44 32 30 32 34 30 34 30 36 0A 44 43 41 44 4D 0A 44 41 59 47 52 45 45 4E 0A 44 43 42 78 78 78 0A 44 43 44 79 79 79 0A 44 41 57 31 32 35 0A 44 41 5A 42 52 4E 0A 44 44 41 46 0A 44 41 55 35 30 31 0A 44 41 48 41 50 54 20 39 30 31 0A 44 43 4C 57 0A 0D ");

            //OH = exp parsing issue with 4.1.0.7
            // byte[] BarCode_Scan = HexStringToByteArray("40 0A 1E 0D 41 4E 53 49 20 36 33 36 30 32 33 30 39 30 31 30 32 44 4C 30 30 34 31 30 33 33 30 5A 4F 30 33 37 31 30 30 35 37 44 4C 44 42 41 30 33 30 35 32 30 32 34 0A 44 43 53 53 43 48 55 4C 4B 45 4E 53 0A 44 41 43 43 48 52 49 53 54 4F 50 48 45 52 0A 44 41 44 52 49 43 48 41 52 44 0A 44 42 44 30 39 30 38 32 30 32 32 0A 44 42 42 30 33 30 35 31 39 38 36 0A 44 42 43 31 0A 44 41 59 42 4C 55 0A 44 41 55 30 36 34 20 69 6E 0A 44 41 47 37 36 36 30 20 48 4F 43 4B 4D 41 4E 20 52 44 0A 44 41 49 52 55 53 53 45 4C 4C 56 49 4C 4C 45 0A 44 41 4A 4F 48 0A 44 41 4B 34 35 31 36 38 30 30 30 30 20 20 0A 44 41 51 55 48 30 32 35 30 37 31 0A 44 43 46 30 31 34 32 33 30 36 34 35 0A 44 43 47 55 53 41 0A 44 44 45 4E 0A 44 44 46 4E 0A 44 44 47 4E 0A 44 41 5A 42 52 4F 0A 44 43 49 54 45 58 41 53 0A 44 43 4A 0A 44 43 55 0A 44 43 45 33 0A 44 44 41 46 0A 44 44 42 30 37 30 31 32 30 31 38 0A 44 44 43 0A 44 41 57 31 34 30 0A 44 44 4C 0A 44 43 41 44 0A 44 43 42 41 0A 44 43 44 4E 4F 4E 45 0A 44 41 48 0A 44 43 4B 43 35 30 38 35 33 33 34 36 0A 44 43 4E 0A 44 43 4F 0A 44 41 58 30 36 33 0A 44 44 48 0A 44 44 49 0A 44 44 4A 0A 44 44 4B 0A 0D 5A 4F 5A 4F 41 4E 0A 5A 4F 42 4E 0A 5A 4F 45 30 33 30 35 32 30 32 34 0A 5A 4F 43 0A 5A 4F 44 0A 5A 4F 46 0A 5A 4F 47 0A 5A 4F 48 0A 5A 4F 49 0A 5A 4F 4B 0A 5A 4F 4C 0A 0D");


            //to test time bomb, use fake card with DocIssueDate set to 2027
            // DBD=20271231-Fictional Card  triggers DocIssueDate = 2027 error - v4.1.0.9
           // byte[] BarCode_Scan = HexStringToByteArray("40 0A 1E 0D 41 4E 53 49 20 36 33 36 30 31 30 30 31 30 32 44 4C 30 30 33 39 30 31 37 38 5A 46 30 32 31 37 30 30 36 35 44 4C 44 41 41 50 45 52 4B 4B 4F 2C 4A 52 2C 50 41 55 4C 2C 56 41 55 47 48 4E 0A 44 41 47 32 32 32 32 20 48 41 4E 4B 53 20 44 52 49 56 45 0A 44 41 49 46 54 20 4D 59 45 52 53 0A 44 41 4A 46 4C 0A 44 41 4B 33 33 39 30 35 2D 32 34 33 35 20 0A 44 41 51 50 36 36 36 37 39 38 30 30 36 32 36 30 0A 44 41 52 45 20 20 20 0A 44 41 53 4E 4F 4E 45 0A 44 41 54 4E 4F 4E 45 0A 44 42 41 32 30 32 33 30 34 30 36 0A 44 42 42 32 30 32 33 31 32 33 31 0A 44 42 43 32 0A 44 42 44 32 30 32 37 30 34 30 36 0A 44 43 41 44 4D 0A 44 41 59 47 52 45 45 4E 0A 44 43 42 78 78 78 0A 44 43 44 79 79 79 0A 44 41 57 31 32 35 0A 44 41 5A 42 52 4E 0A 44 44 41 46 0A 44 41 55 35 30 31 0A 44 41 48 41 50 54 20 39 30 31 0A 44 43 4C 57 0A 0D ");
            
            Array.Resize(ref buff, BarCode_Scan.Length); //You MUST resize the data, the buffer sent must contain only card data, no preceding bytes generated by a scanner, and no trailing garbage data. Normally the length is created from the SerialPort.BytesToRead property.

            Array.Copy(BarCode_Scan, buff, BarCode_Scan.Length);// copy input to global buffer

            try
            {
                this.Invoke(new EventHandler(SendPDF));  // always call the DLLs with a try/catch
            }
            catch
            {
                MessageBox.Show("Invalid Barcode");
            }
            displaystring = PdfSrvr.Barcode.PDF_String; // display the ASCII version of the input data
            this.Invoke(new EventHandler(SetText));


        }


        private void SetText(object o, EventArgs e)
        {
            txtOutput.Text = displaystring;
        }


        private void SendMAG(object sender, EventArgs e)
        {
 
            int ret = 0;
            try
            {
                mc = new MagSrvr.Magstripe();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error loading MagSrvr");
                return;

            }


            ret = mc.ParseDL(MagBuff); // Parse the buffer



                stateP_DL = Magstripe.stateP_DL;
                cityP_DL = Magstripe.cityP_DL;
                addrP_DL = Magstripe.addrP_DL;
                firstnameP_DL = Magstripe.firstnameP_DL;
                lastnameP_DL = Magstripe.lastnameP_DL;
                midnameP_DL = Magstripe.midnameP_DL;
                titleP_DL = Magstripe.titleP_DL;
                dlP_DL = Magstripe.dlP_DL;
                expP_DL = Magstripe.expP_DL;
                dobyearP_DL = Magstripe.dobyearP_DL;
                dobMMDDP_DL = Magstripe.dobMMDDP_DL;
                zipP_DL = Magstripe.zipP_DL;
                ClassP_DL = Magstripe.ClassP_DL;
                RestrictionsP_DL = Magstripe.RestrictionsP_DL;
                EndorsementsP_DL = Magstripe.EndorsementsP_DL;
                SexP_DL = Magstripe.SexP_DL;
                HeightP_DL = Magstripe.HeightP_DL;
                WeightP_DL = Magstripe.WeightP_DL;
                HairP_DL = Magstripe.HairP_DL;
                EyeColorP_DL = Magstripe.EyeP_DL;


                txtFirst.Text = firstnameP_DL;
                txtLast.Text = lastnameP_DL;
                txtMid.Text = midnameP_DL;
                txtTitle.Text = titleP_DL;
                txtID.Text = dlP_DL;
                txtState.Text = stateP_DL;
                txtCity.Text = cityP_DL;
                txtAddress.Text = addrP_DL;
                txtEXP.Text = expP_DL;
                txtZip.Text = zipP_DL;
                txtClass.Text = ClassP_DL;
                txtRestriction.Text = RestrictionsP_DL;
                txtEndorsement.Text = EndorsementsP_DL;
                txtSEX.Text = SexP_DL;
                txtHeight.Text = HeightP_DL;
                txtWeight.Text = WeightP_DL;
                txtHair.Text = HairP_DL;
                txtEye.Text = EyeColorP_DL;
                txtDobMMDD.Text = dobMMDDP_DL;
                txtDobYear.Text = dobyearP_DL;
                txtIsoBin.Text = Magstripe.IsoBin_DL; //new for v 4.1.0.8
                txtIssuingState.Text = Magstripe.IsuingState_DL; //new v 4.1.0.8

            // Bank Cards
                textFirstCC.Text = Magstripe.firstname_CC;
                textLastCC.Text = Magstripe.lastname_CC;
                textExpMMCC.Text = Magstripe.EXPMM_CC;
                textExpYYCC.Text = Magstripe.EXPYY_CC;
                textPanCC.Text = Magstripe.PAN_CC;
                //display return code
                txtRetMag.Text = ret.ToString();

//These fields are not available on magstripe
                txtCountry.Text = ""; //n/a
                txtRace.Text = ""; // n/a
                txtDBD.Text = ""; // n/a
                txtAddr2.Text = ""; // n/a
                txtRealID.Text = ""; // n/a

                //license fields
                txtKeyStatus.Text = Magstripe.KeyStatus;
                txtKeyResponse.Text = Magstripe.KeyResponse.ToString();
                txtLicenseID.Text = Magstripe.KeyLicenseID;
                txtInstallationID.Text = Magstripe.KeyInstallationID;
                txtRev.Text = Magstripe.Version;




        }


        private void SendPDF(object sender, EventArgs e)
        {


            int i = -1;

             try
            {
                bc = new PdfSrvr.Barcode();
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message, "Error loading PdfSrvr");
                return;

            }

            i = bc.Parse417(buff); // Parse the buffer
            
            stateP_DL = Barcode.State_DL;
            cityP_DL = Barcode.City_DL;
            addrP_DL = Barcode.Addr_DL;
            firstnameP_DL = Barcode.First_DL;
            lastnameP_DL = Barcode.Last_DL;
            midnameP_DL = Barcode.Mid_DL;
            titleP_DL = Barcode.Title_DL;
            dlP_DL = Barcode.Dl_DL;
            expP_DL = Barcode.Exp_DL;
            dobyearP_DL = Barcode.DobYear_DL;
            dobMMDDP_DL = Barcode.DobMMDD_DL;
            zipP_DL = Barcode.Zip_DL;
            HeightP_DL = Barcode.Height_DL;
            EyeColorP_DL = Barcode.Eye_DL;
            SexP_DL = Barcode.Sex_DL;
            ClassP_DL = Barcode.Class_DL;
            RestrictionsP_DL = Barcode.Rest_DL;
            EndorsementsP_DL = Barcode.Endr_DL;
            WeightP_DL = Barcode.Wt_DL;
            HairP_DL = Barcode.Hair_DL;

            //Loading Gui Object from local app variables
            txtFirst.Text = firstnameP_DL;
            txtLast.Text = lastnameP_DL;
            txtMid.Text = midnameP_DL;
            txtAddress.Text = addrP_DL;
            txtCity.Text = cityP_DL;
            txtState.Text = stateP_DL;
            txtZip.Text = zipP_DL;
            txtID.Text = dlP_DL;
            txtSEX.Text = SexP_DL;
            txtEXP.Text = expP_DL;
            txtTitle.Text = titleP_DL;
            txtEye.Text = EyeColorP_DL;
            txtHeight.Text = HeightP_DL;
            txtDobMMDD.Text = dobMMDDP_DL;
            txtDobYear.Text = dobyearP_DL;
            txtClass.Text = ClassP_DL;
            txtRestriction.Text = RestrictionsP_DL;
            txtEndorsement.Text = EndorsementsP_DL;
            txtWeight.Text = WeightP_DL;
            txtHair.Text = HairP_DL;
            //display return code
            txtRetPDF.Text = i.ToString();
            txtIsoBin.Text = Barcode.IsoBin_DL; //new for v 4.1.0.8
            txtIssuingState.Text = Barcode.IsuingState_DL; //new for v 4.1.0.8
 

            //These fields are available on barcode only
            txtAddr2.Text = Barcode.Addr2_DL;
            txtCountry.Text = Barcode.Country_DL;
            txtRace.Text = Barcode.Race_DL;
            txtDBD.Text = Barcode.DocIssDate_DL;
            txtRealID.Text = Barcode.RealID_DL;

            //license fields
            txtKeyStatus.Text = Barcode.KeyStatus;
            txtKeyResponse.Text = Barcode.KeyResponse.ToString();
            txtLicenseID.Text = Barcode.KeyLicenseID;
            txtInstallationID.Text = Barcode.KeyInstallationID;

            txtRev.Text = Barcode.Version;
//This snippet will manually update status for v4.1.0.7
            if(string.IsNullOrEmpty(txtLast.Text)) //lastname is blanked when timebomb is hit (based on DocIssueDate)
            txtKeyStatus.Text = "V4.1.0.9 s.w. maint. expired- DocIssueDate Trigger on 2026";
            else
                txtKeyStatus.Text = "V4.1.0.9- Status OK";
        }


        #endregion

        #region ComInterface
        private void btnInterface_Click(object sender, EventArgs e)
        {
            //DocIssDate=2024
            byte[] BarCode_Scan = HexStringToByteArray("40 0A 1C 0D 41 41 4D 56 41 33 36 30 30 31 30 30 31 44 4C 30 30 31 32 33 34 35 36 44 4C 0A 44 41 41 54 4F 4B 45 4E 57 4F 52 4B 53 40 54 4F 4D 40 54 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0A 44 41 47 34 34 20 45 20 39 39 54 48 20 53 54 20 41 50 54 20 39 30 31 0A 44 41 49 4E 45 57 20 59 4F 52 4B 20 20 20 20 20 20 20 0A 44 41 4A 4E 59 0A 44 41 4B 31 30 31 32 38 20 20 20 20 20 20 0A 44 41 51 33 36 32 38 33 32 35 31 32 20 20 0A 44 42 42 31 39 38 37 30 38 30 32 0A 44 42 44 32 30 32 34 31 30 30 34 0A 44 42 41 32 30 31 33 30 35 30 37 0A 44 41 52 44 4D 20 20 0A 44 41 53 20 20 20 20 20 20 20 20 20 20 0A 44 41 54 20 20 20 20 20 20 0A 44 42 43 4D 0A 44 41 55 36 30 32 0A 44 41 59 42 52 20 0A 44 42 4B 20 20 20 20 20 20 20 20 20 0A 44 42 48 20 20 20 20 20 20 20 20 20 20 0D");
            //test string to trigger error message when doc Issue = 2025
         // byte[] BarCode_Scan = HexStringToByteArray("40 0A 1C 0D 41 41 4D 56 41 33 36 30 30 31 30 30 31 44 4C 30 30 31 32 33 34 35 36 44 4C 0A 44 41 41 54 4F 4B 45 4E 57 4F 52 4B 53 40 54 4F 4D 40 54 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 0A 44 41 47 34 34 20 45 20 39 39 54 48 20 53 54 20 41 50 54 20 39 30 31 0A 44 41 49 4E 45 57 20 59 4F 52 4B 20 20 20 20 20 20 20 0A 44 41 4A 4E 59 0A 44 41 4B 31 30 31 32 38 20 20 20 20 20 20 0A 44 41 51 33 36 32 38 33 32 35 31 32 20 20 0A 44 42 42 31 39 38 37 30 38 30 32 0A 44 42 44 32 30 32 35 31 30 30 34 0A 44 42 41 32 30 31 33 30 35 30 37 0A 44 41 52 44 4D 20 20 0A 44 41 53 20 20 20 20 20 20 20 20 20 20 0A 44 41 54 20 20 20 20 20 20 0A 44 42 43 4D 0A 44 41 55 36 30 32 0A 44 41 59 42 52 20 0A 44 42 4B 20 20 20 20 20 20 20 20 20 0A 44 42 48 20 20 20 20 20 20 20 20 20 20 0D");
          
            Array.Resize(ref buff, BarCode_Scan.Length); //You MUST resize the data, the buffer sent must contain only card data, no preceding bytes generated by a scanner, and no trailing garbage data. Normally the length is created from the SerialPort.BytesToRead property.

            Array.Copy(BarCode_Scan, buff, BarCode_Scan.Length);// copy input to global buffer

            int i = -1;
            PdfSrvr.Barcode ibc;
            ibc = new PdfSrvr.Barcode();

            i = ibc.Parse417(buff); // Parse the buffer

            txtRetPDF.Text = ibc.problem_ID.ToString();
            txtTitle.Text = ibc.Title_ID;
            txtFirst.Text = ibc.FirstName_ID;
            txtMid.Text = ibc.Mid_ID;
            txtLast.Text = ibc.Last_ID;

            txtAddress.Text = ibc.Addr_ID;
            txtAddr2.Text = ibc.Addr2_ID;
            txtCity.Text = ibc.City_ID;
            txtState.Text = ibc.State_ID;
            txtZip.Text = ibc.Zip_ID;
            txtID.Text = ibc.Dl_ID;
            txtEXP.Text = ibc.Exp_ID;
            txtDobYear.Text = ibc.DobYear_ID;
            txtDobMMDD.Text = ibc.DobMMDD_ID;
            txtDBD.Text = ibc.DocIssDate_ID;

            txtHeight.Text = ibc.Height_ID;
            txtWeight.Text = ibc.Wt_ID;
            txtEye.Text = ibc.Eye_ID;
            txtSEX.Text = ibc.Sex_ID;
            txtHair.Text = ibc.Hair_ID;

            txtClass.Text = ibc.DLClass_ID;
            txtRestriction.Text = ibc.Rest_ID;
            txtEndorsement.Text = ibc.Endr_ID;

            txtCountry.Text = ibc.Country_ID;
            txtRace.Text = ibc.Race_ID;
            txtIsoBin.Text = ibc.IsoBin_ID; //new for v 4.1.0.8
            txtIssuingState.Text = ibc.IsuingState_ID; //new for v 4.1.0.8



            //license fields
            txtKeyStatus.Text = ibc.keyrespstr_ID;
            txtKeyResponse.Text = ibc.keyresponse_ID.ToString();



        }

        private void btnIparsedMag_Click(object sender, EventArgs e)
        {
            byte[] Magstripe_Scan = HexStringToByteArray("25 4E 59 41 4C 42 41 4E 59 5E 54 4F 4B 45 4E 57 4F 52 4B 53 24 4A 4F 45 34 24 54 5E 38 33 34 20 43 4F 4E 43 48 20 53 48 45 4C 4C 20 52 44 20 20 20 20 23 39 30 31 5E 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 3F 3B 36 33 36 30 31 30 30 33 32 34 31 36 38 33 36 33 31 33 37 3D 30 37 30 32 31 39 38 34 39 39 30 34 30 3D 3F 25 21 20 31 32 33 34 34 30 30 30 30 20 20 45 20 42 20 20 20 20 20 20 20 20 20 20 20 20 20 31 35 30 36 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 20 4E 2F 26 2B 47 47 30 30 30 30 30 3F");
            Array.Resize(ref MagBuff, Magstripe_Scan.Length); //You MUST resize the data, the buffer sent must contain only card data, no preceding bytes generated by a scanner, and no trailing garbage data. Normally the length is created from the SerialPort.BytesToRead property.
            Array.Copy(Magstripe_Scan, 0, MagBuff, 0, Magstripe_Scan.Length); // copy the scan from your SerialDataReceivedEventHandler into the global MagBuff array

            int ret = -1;
            MagSrvr.Magstripe imc;
            imc = new MagSrvr.Magstripe();

            

            ret = imc.ParseDL(MagBuff); // Parse the buffer

            txtRetPDF.Text = imc.problem_ID.ToString();
            txtTitle.Text = imc.Title_ID;
            txtFirst.Text = imc.FirstName_ID;
            txtMid.Text = imc.Mid_ID;
            txtLast.Text = imc.Last_ID;

            txtAddress.Text = imc.Addr_ID;
            txtAddr2.Text = imc.Addr2_ID; //always emptry string, missing from Mag DLs
            txtCity.Text = imc.City_ID;
            txtState.Text = imc.State_ID;
            txtZip.Text = imc.Zip_ID;
            txtID.Text = imc.Dl_ID;
            txtEXP.Text = imc.Exp_ID;
            txtDobYear.Text = imc.DobYear_ID;
            txtDobMMDD.Text = imc.DobMMDD_ID;
            txtDBD.Text = imc.DocIssDate_ID; //always emptry string, missing from Mag DLs

            txtHeight.Text = imc.Height_ID;
            txtWeight.Text = imc.Wt_ID;
            txtEye.Text = imc.Eye_ID;
            txtSEX.Text = imc.Sex_ID;
            txtHair.Text = imc.Hair_ID;

            txtClass.Text = imc.DLClass_ID;
            txtRestriction.Text = imc.Rest_ID;
            txtEndorsement.Text = imc.Endr_ID;
            txtIsoBin.Text = imc.IsoBin_ID; //new for v 4.1.0.8
            txtIssuingState.Text = imc.IsuingState_ID; //new for v 4.1.0.8

            txtCountry.Text = imc.Country_ID; //always emptry string, missing from Mag DLs
            txtRace.Text = imc.Race_ID; //always emptry string, missing from Mag DLs

            //license fields
            txtKeyStatus.Text = imc.keyrespstr_ID;
            txtKeyResponse.Text = imc.keyresponse_ID.ToString();


        }
        #endregion

        #region Launch License Manager

  
 
        #endregion
 
    }
}